// generated by Fast Light User Interface Designer (fluid) version 1.0300

#include "/home/ddong/COSM_Source_Base/build/viewer/gui/ViewerGUI.h"
#include "FL/Fl_Native_File_Chooser.H"
#include <FL/Fl_Sys_Menu_Bar.H>
#include <FL/fl_ask.H>
#include "ViewerAbout.h"
#include "Fl_VTK_Window.H"
#include "ViewerBase.h"
#include <vtkObjectFactory.h>
#include <vtkRenderWindow.h>
#include <vtkInteractorStyleImage.h>
#include <vtkRenderWindowInteractor.h>
/* fool fluid */
vtkCxxRevisionMacro (ViewerGUI, "$Revision: 1.4 $");
/* fool fluid */
vtkStandardNewMacro (ViewerGUI);

void ViewerGUI::cb_Open_i(Fl_Menu_*, void*) {
  const char* filename;
Fl_Native_File_Chooser native;

native.title("Image File");
native.type(Fl_Native_File_Chooser::BROWSE_FILE);
native.filter("*.wu\n*.{wu,tiff,tiff,png,pnm,pgm,ppm,jpg,jpeg}\n*.{tif, tiff}\n*.png\n*.{pnm,pgm,ppm}\n*.{jpg,jpeg}");
native.show();
filename = native.filename();
 
printf("Filename: %s\n", filename);
if ( (filename != NULL) && (filename != "") ) {
    this->viewerBase->SetFileName(filename);
    char label[512] = "COSM Viewer - ";
    strcat( label, filename );
    this->mWindow->label(label);
    this->viewerBase->Pipeline();
    this->Show();
}
else
{
    fl_alert("Unknown Image Filename");
};
}
void ViewerGUI::cb_Open(Fl_Menu_* o, void* v) {
  ((ViewerGUI*)(o->parent()->user_data()))->cb_Open_i(o,v);
}

void ViewerGUI::cb_Save_i(Fl_Menu_*, void*) {
  const char* filename;
Fl_Native_File_Chooser native;

native.title("WU File");
native.type(Fl_Native_File_Chooser::BROWSE_SAVE_FILE);
native.filter("*.wu");
native.show();
filename = native.filename();
 
printf("Filename: %s\n", filename);
if ( (filename != NULL) && (filename != "") ) {
    this->viewerBase->WriteFile(filename);
};
}
void ViewerGUI::cb_Save(Fl_Menu_* o, void* v) {
  ((ViewerGUI*)(o->parent()->user_data()))->cb_Save_i(o,v);
}

void ViewerGUI::cb_Quit_i(Fl_Menu_*, void*) {
  exit(0);
}
void ViewerGUI::cb_Quit(Fl_Menu_* o, void* v) {
  ((ViewerGUI*)(o->parent()->user_data()))->cb_Quit_i(o,v);
}

void ViewerGUI::cb_About_i(Fl_Menu_*, void*) {
  if (!aboutDialog) {
    make_about();
}
aboutDialog->show();
}
void ViewerGUI::cb_About(Fl_Menu_* o, void* v) {
  ((ViewerGUI*)(o->parent()->user_data()))->cb_About_i(o,v);
}

Fl_Menu_Item ViewerGUI::menu_[] = {
 {"File", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {"Open", 0,  (Fl_Callback*)ViewerGUI::cb_Open, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Save", 0,  (Fl_Callback*)ViewerGUI::cb_Save, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Quit", 0,  (Fl_Callback*)ViewerGUI::cb_Quit, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {"Help", 0,  0, 0, 64, FL_NORMAL_LABEL, 0, 14, 0},
 {"About...", 0,  (Fl_Callback*)ViewerGUI::cb_About, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0},
 {0,0,0,0,0,0,0,0,0}
};

void ViewerGUI::cb_Graph_i(Fl_Button*, void*) {
  this->MakeGraph();
}
void ViewerGUI::cb_Graph(Fl_Button* o, void* v) {
  ((ViewerGUI*)(o->parent()->parent()->user_data()))->cb_Graph_i(o,v);
}

void ViewerGUI::cb_Clear_i(Fl_Button*, void*) {
  graphCanvas->clear();
activeGraph = false;
}
void ViewerGUI::cb_Clear(Fl_Button* o, void* v) {
  ((ViewerGUI*)(o->parent()->parent()->user_data()))->cb_Clear_i(o,v);
}

void ViewerGUI::cb_Linear_i(Fl_Menu_*, void*) {
  yAxis->scale(CA_LIN);
yAxis->minimum(0); 
//yAxis->maximum(1);
}
void ViewerGUI::cb_Linear(Fl_Menu_* o, void* v) {
  ((ViewerGUI*)(o->parent()->parent()->user_data()))->cb_Linear_i(o,v);
}

void ViewerGUI::cb_Logarithmic_i(Fl_Menu_*, void*) {
  yAxis->scale(CA_LOG);
yAxis->minimum(1e-9); 
//yAxis->maximum(1);
}
void ViewerGUI::cb_Logarithmic(Fl_Menu_* o, void* v) {
  ((ViewerGUI*)(o->parent()->parent()->user_data()))->cb_Logarithmic_i(o,v);
}

Fl_Menu_Item ViewerGUI::menu_scaleChoice[] = {
 {"Linear", 0,  (Fl_Callback*)ViewerGUI::cb_Linear, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {"Logarithmic", 0,  (Fl_Callback*)ViewerGUI::cb_Logarithmic, 0, 0, FL_NORMAL_LABEL, 0, 14, 0},
 {0,0,0,0,0,0,0,0,0}
};

Fl_Menu_Item ViewerGUI::menu_intersectChoice[] = {
 {"XY and XZ Plane", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 1},
 {"XY and YZ Plane", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 6},
 {"XZ and YZ Plane", 0,  0, 0, 0, FL_NORMAL_LABEL, 0, 14, 2},
 {0,0,0,0,0,0,0,0,0}
};

void ViewerGUI::cb_zSlider_i(Fl_Value_Slider*, void*) {
  this->SetZSlice((int)zSlider->value());
}
void ViewerGUI::cb_zSlider(Fl_Value_Slider* o, void* v) {
  ((ViewerGUI*)(o->parent()->parent()->user_data()))->cb_zSlider_i(o,v);
}

void ViewerGUI::cb_ySlider_i(Fl_Value_Slider*, void*) {
  this->SetYSlice((int)ySlider->value());
}
void ViewerGUI::cb_ySlider(Fl_Value_Slider* o, void* v) {
  ((ViewerGUI*)(o->parent()->parent()->user_data()))->cb_ySlider_i(o,v);
}

void ViewerGUI::cb_xSlider_i(Fl_Value_Slider*, void*) {
  this->SetXSlice((int)xSlider->value());
}
void ViewerGUI::cb_xSlider(Fl_Value_Slider* o, void* v) {
  ((ViewerGUI*)(o->parent()->parent()->user_data()))->cb_xSlider_i(o,v);
}

void ViewerGUI::cb_levelSlider_i(Fl_Value_Slider*, void*) {
  this->viewerBase->SetLevel(levelSlider->value());
this->Render();
}
void ViewerGUI::cb_levelSlider(Fl_Value_Slider* o, void* v) {
  ((ViewerGUI*)(o->parent()->parent()->user_data()))->cb_levelSlider_i(o,v);
}

void ViewerGUI::cb_windowSlider_i(Fl_Value_Slider*, void*) {
  this->viewerBase->SetWindow(windowSlider->value());
this->Render();
}
void ViewerGUI::cb_windowSlider(Fl_Value_Slider* o, void* v) {
  ((ViewerGUI*)(o->parent()->parent()->user_data()))->cb_windowSlider_i(o,v);
}

void ViewerGUI::cb_Reset_i(Fl_Button*, void*) {
  this->volView->GetDefaultRenderer()->ResetCamera();
this->Render();
}
void ViewerGUI::cb_Reset(Fl_Button* o, void* v) {
  ((ViewerGUI*)(o->parent()->user_data()))->cb_Reset_i(o,v);
}

ViewerGUI::ViewerGUI() : viewerBase( new ViewerBase), activeGraph(false) {
  { mWindow = new Fl_Double_Window(966, 830, "COSM Viewer");
    mWindow->user_data((void*)(this));
    { Fl_Sys_Menu_Bar* o = new Fl_Sys_Menu_Bar(0, 0, 1000, 25);
      o->box(FL_UP_BOX);
      o->color(FL_BACKGROUND_COLOR);
      o->selection_color(FL_SELECTION_COLOR);
      o->labeltype(FL_NORMAL_LABEL);
      o->labelfont(0);
      o->labelsize(14);
      o->labelcolor(FL_FOREGROUND_COLOR);
      o->align(Fl_Align(FL_ALIGN_CENTER));
      o->when(FL_WHEN_RELEASE_ALWAYS);
      o->menu(menu_);
    } // Fl_Sys_Menu_Bar* o
    { Fl_Group* o = new Fl_Group(475, 40, 475, 445);
      o->box(FL_ENGRAVED_BOX);
      o->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      { Ca_Canvas* o = graphCanvas = new Ca_Canvas(560, 72, 370, 278);
        graphCanvas->box(FL_ENGRAVED_BOX);
        graphCanvas->color(FL_BACKGROUND2_COLOR);
        graphCanvas->selection_color(FL_BACKGROUND_COLOR);
        graphCanvas->labeltype(FL_NORMAL_LABEL);
        graphCanvas->labelfont(0);
        graphCanvas->labelsize(14);
        graphCanvas->labelcolor(FL_FOREGROUND_COLOR);
        graphCanvas->align(Fl_Align(FL_ALIGN_CENTER));
        graphCanvas->when(FL_WHEN_RELEASE);
        o->current();
      } // Ca_Canvas* graphCanvas
      { Ca_Y_Axis* o = yAxis = new Ca_Y_Axis(485, 64, 75, 329, "Intensity");
        yAxis->box(FL_NO_BOX);
        yAxis->color(FL_BACKGROUND_COLOR);
        yAxis->selection_color(FL_BACKGROUND_COLOR);
        yAxis->labeltype(FL_NORMAL_LABEL);
        yAxis->labelfont(0);
        yAxis->labelsize(14);
        yAxis->labelcolor(FL_FOREGROUND_COLOR);
        yAxis->align(Fl_Align(FL_ALIGN_TOP_LEFT));
        yAxis->when(FL_WHEN_RELEASE);
        o->grid_visible(CA_MINOR_TICK|CA_MAJOR_TICK|CA_LABEL_GRID|CA_ALWAYS_VISIBLE);
        o->minor_grid_color(FL_RED); o->major_grid_color(FL_RED); o->label_grid_color(FL_RED); o->label_size(10); //o->label_format("%3.1e");
        o->minimum(0); o->maximum(1);
        o->scale(CA_LIN); o->current();
      } // Ca_Y_Axis* yAxis
      { Ca_X_Axis* o = xAxis = new Ca_X_Axis(540, 347, 400, 46, "sample");
        xAxis->box(FL_NO_BOX);
        xAxis->color(FL_BACKGROUND_COLOR);
        xAxis->selection_color(FL_BACKGROUND_COLOR);
        xAxis->labeltype(FL_NORMAL_LABEL);
        xAxis->labelfont(0);
        xAxis->labelsize(14);
        xAxis->labelcolor(FL_FOREGROUND_COLOR);
        xAxis->align(Fl_Align(FL_ALIGN_BOTTOM_RIGHT));
        xAxis->when(FL_WHEN_RELEASE);
        o->grid_visible(CA_MINOR_TICK|CA_MAJOR_TICK|CA_LABEL_GRID|CA_ALWAYS_VISIBLE);
        o->minor_grid_color(FL_RED); o->major_grid_color(FL_RED); o->label_grid_color(FL_RED); o->label_size(10);
        o->minimum(0); o->maximum(100);
        o->current();
      } // Ca_X_Axis* xAxis
      { Fl_Button* o = new Fl_Button(795, 415, 135, 25, "Graph");
        o->tooltip("Plot the intersection in graph area");
        o->callback((Fl_Callback*)cb_Graph);
      } // Fl_Button* o
      { Fl_Button* o = new Fl_Button(795, 440, 135, 25, "Clear");
        o->tooltip("Clear the plots in graph area");
        o->callback((Fl_Callback*)cb_Clear);
      } // Fl_Button* o
      { scaleChoice = new Fl_Choice(655, 440, 135, 25, "Scale: ");
        scaleChoice->tooltip("Linear or Logarithmic plotting");
        scaleChoice->down_box(FL_BORDER_BOX);
        scaleChoice->menu(menu_scaleChoice);
      } // Fl_Choice* scaleChoice
      { intersectChoice = new Fl_Choice(655, 415, 135, 25, "Intersection: ");
        intersectChoice->tooltip("Intersection of two planes to plot");
        intersectChoice->down_box(FL_BORDER_BOX);
        intersectChoice->menu(menu_intersectChoice);
      } // Fl_Choice* intersectChoice
      o->end();
    } // Fl_Group* o
    { Fl_VTK_Window* o = volView = new Fl_VTK_Window(15, 40, 445, 420);
      volView->tooltip("Right button - zoom,  Left button - rotate/pick value");
      volView->box(FL_ENGRAVED_BOX);
      volView->color(FL_BACKGROUND_COLOR);
      volView->selection_color(FL_BACKGROUND_COLOR);
      volView->labeltype(FL_NO_LABEL);
      volView->labelfont(0);
      volView->labelsize(14);
      volView->labelcolor(FL_FOREGROUND_COLOR);
      volView->align(Fl_Align(FL_ALIGN_CENTER));
      volView->when(FL_WHEN_ENTER_KEY);
      o->resizable(*o);
    } // Fl_VTK_Window* volView
    { Fl_Group* o = new Fl_Group(15, 500, 745, 315);
      o->box(FL_ENGRAVED_BOX);
      { zSlider = new Fl_Value_Slider(40, 780, 220, 20, "Z:");
        zSlider->tooltip("Select XY Plane  (Z value)");
        zSlider->type(5);
        zSlider->maximum(0);
        zSlider->step(1);
        zSlider->slider_size(0.070707);
        zSlider->callback((Fl_Callback*)cb_zSlider, (void*)(this));
        zSlider->align(Fl_Align(FL_ALIGN_LEFT));
      } // Fl_Value_Slider* zSlider
      { ySlider = new Fl_Value_Slider(285, 780, 220, 20, "Y:");
        ySlider->tooltip("Select XZ Plane  (Y value)");
        ySlider->type(5);
        ySlider->maximum(0);
        ySlider->step(1);
        ySlider->slider_size(0.070707);
        ySlider->callback((Fl_Callback*)cb_ySlider, (void*)(this));
        ySlider->align(Fl_Align(FL_ALIGN_LEFT));
      } // Fl_Value_Slider* ySlider
      { xSlider = new Fl_Value_Slider(530, 780, 220, 20, "X:");
        xSlider->tooltip("Select YZ Plane  (X value)");
        xSlider->type(5);
        xSlider->maximum(0);
        xSlider->step(1);
        xSlider->slider_size(0.070707);
        xSlider->callback((Fl_Callback*)cb_xSlider, (void*)(this));
        xSlider->align(Fl_Align(FL_ALIGN_LEFT));
      } // Fl_Value_Slider* xSlider
      { Fl_Group* o = new Fl_Group(20, 530, 240, 240, "XY Plane");
        o->box(FL_ENGRAVED_BOX);
        { Fl_VTK_Window* o = zView = new Fl_VTK_Window(20, 530, 240, 240);
          zView->tooltip("Right button - zoom,  Middle button - move");
          zView->box(FL_NO_BOX);
          zView->color(FL_BACKGROUND_COLOR);
          zView->selection_color(FL_BACKGROUND_COLOR);
          zView->labeltype(FL_NO_LABEL);
          zView->labelfont(0);
          zView->labelsize(14);
          zView->labelcolor(FL_FOREGROUND_COLOR);
          zView->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          zView->when(FL_WHEN_RELEASE);
          o->resizable(*o);
        } // Fl_VTK_Window* zView
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(265, 530, 240, 240, "ZX Plane");
        o->box(FL_ENGRAVED_BOX);
        { Fl_VTK_Window* o = yView = new Fl_VTK_Window(265, 530, 240, 240);
          yView->tooltip("Right button - zoom,  Middle button - move");
          yView->box(FL_NO_BOX);
          yView->color(FL_BACKGROUND_COLOR);
          yView->selection_color(FL_BACKGROUND_COLOR);
          yView->labeltype(FL_NO_LABEL);
          yView->labelfont(0);
          yView->labelsize(14);
          yView->labelcolor(FL_FOREGROUND_COLOR);
          yView->align(Fl_Align(FL_ALIGN_TOP));
          yView->when(FL_WHEN_RELEASE);
          o->resizable(*o);
        } // Fl_VTK_Window* yView
        o->end();
      } // Fl_Group* o
      { Fl_Group* o = new Fl_Group(510, 530, 240, 240, "YZ Plane");
        o->box(FL_ENGRAVED_BOX);
        { Fl_VTK_Window* o = xView = new Fl_VTK_Window(510, 530, 240, 240);
          xView->tooltip("Right button - zoom,  Middle button - move");
          xView->box(FL_NO_BOX);
          xView->color(FL_BACKGROUND_COLOR);
          xView->selection_color(FL_BACKGROUND_COLOR);
          xView->labeltype(FL_NORMAL_LABEL);
          xView->labelfont(0);
          xView->labelsize(14);
          xView->labelcolor(FL_FOREGROUND_COLOR);
          xView->align(Fl_Align(FL_ALIGN_TOP));
          xView->when(FL_WHEN_RELEASE);
          o->resizable(*o);
        } // Fl_VTK_Window* xView
        o->end();
      } // Fl_Group* o
      o->end();
    } // Fl_Group* o
    { Fl_Group* o = new Fl_Group(770, 500, 180, 315);
      o->box(FL_ENGRAVED_BOX);
      { Fl_VTK_Window* o = bView = new Fl_VTK_Window(785, 535, 85, 235);
        bView->tooltip("Gray level to value mapping");
        bView->box(FL_ENGRAVED_BOX);
        bView->color(FL_BACKGROUND_COLOR);
        bView->selection_color(FL_BACKGROUND_COLOR);
        bView->labeltype(FL_NORMAL_LABEL);
        bView->labelfont(0);
        bView->labelsize(14);
        bView->labelcolor(FL_FOREGROUND_COLOR);
        bView->align(Fl_Align(FL_ALIGN_TOP));
        bView->when(FL_WHEN_RELEASE);
        o->resizable(*o);
      } // Fl_VTK_Window* bView
      { levelSlider = new Fl_Value_Slider(880, 535, 25, 235, "Level");
        levelSlider->tooltip("Select Window-Level Transfer function (Center value)");
        levelSlider->type(4);
        levelSlider->labelsize(12);
        levelSlider->step(0.001);
        levelSlider->value(0.5);
        levelSlider->callback((Fl_Callback*)cb_levelSlider);
        levelSlider->align(Fl_Align(FL_ALIGN_TOP));
      } // Fl_Value_Slider* levelSlider
      { windowSlider = new Fl_Value_Slider(910, 535, 25, 235, "Window");
        windowSlider->tooltip("Select Window-Level Transfer function (window size)");
        windowSlider->type(4);
        windowSlider->labelsize(12);
        windowSlider->step(0.001);
        windowSlider->value(1);
        windowSlider->callback((Fl_Callback*)cb_windowSlider);
        windowSlider->align(Fl_Align(FL_ALIGN_TOP));
      } // Fl_Value_Slider* windowSlider
      o->end();
    } // Fl_Group* o
    { Fl_Button* o = new Fl_Button(325, 460, 134, 25, "Reset Size");
      o->callback((Fl_Callback*)cb_Reset);
    } // Fl_Button* o
    mWindow->end();
    mWindow->resizable(mWindow);
  } // Fl_Double_Window* mWindow
  this->mWindow->user_data((void*)this);
  this->zView->user_data((void*)this);
  this->yView->user_data((void*)this);
  this->xView->user_data((void*)this);
  
  this->volView->user_data((void*)this);
  this->bView->user_data((void*)this);
  
  vtkInteractorStyleImage* imageStyle1 = vtkInteractorStyleImage::New();
  this->xView->GetInteractor()->SetInteractorStyle(imageStyle1);
  vtkInteractorStyleImage* imageStyle2 = vtkInteractorStyleImage::New();
  this->yView->GetInteractor()->SetInteractorStyle(imageStyle2);
  vtkInteractorStyleImage* imageStyle3 = vtkInteractorStyleImage::New();
  this->zView->GetInteractor()->SetInteractorStyle(imageStyle3);
  
  vtkInteractorStyleImage* imageStyle4 = vtkInteractorStyleImage::New();
  this->bView->GetInteractor()->SetInteractorStyle(imageStyle4);
  colorGraph[0] = FL_BLACK;
  colorGraph[1] = FL_RED;
  colorGraph[3] = FL_GREEN;
  colorGraph[4] = FL_YELLOW;
  colorGraph[5] = FL_BLUE;
  colorGraph[6] = FL_MAGENTA;
  colorGraph[7] = FL_CYAN;
  colorGraph[8] = FL_DARK_RED;
  colorGraph[9] = FL_DARK_YELLOW;
  colorGraph[10] = FL_DARK_BLUE;
  colorGraph[11] = FL_DARK_MAGENTA;
  colorGraph[12] = FL_DARK_CYAN;
  selColor = 0;
}

ViewerGUI::~ViewerGUI() {
  if (this->mWindow != (Fl_Window *) 0)
    {
      this->mWindow->hide();
      delete this->mWindow;
    }
    
  delete viewerBase;
}

void ViewerGUI::UpdateView(void) {
  if ( zView != NULL )
  {
      this->zView->Update();
  }
  if ( yView != NULL )
  {
      this->yView->Update();
  }
  if ( xView != NULL )
  {
      this->xView->Update();
  }
  
  if ( volView != NULL )
  {
      this->volView->Update();
  }
  if ( bView != NULL )
  {
      this->bView->Update();
  }
}

void ViewerGUI::Show( void ) {
  if (this->mWindow != (Fl_Window *) 0)
  {       
      if ( this->volView != NULL)
      {
          this->viewerBase->AddActorsVol(this->volView->GetRenderWindow(), this->volView->GetDefaultRenderer());
      }                                                               
      if ( this->zView != NULL)
      {
          this->viewerBase->AddActorsPlane(2,this->zView->GetRenderWindow(), this->zView->GetDefaultRenderer());
      }     
      if ( this->yView != NULL)
      {
          this->viewerBase->AddActorsPlane(1,this->yView->GetRenderWindow(), this->yView->GetDefaultRenderer());
      } 
      if ( this->xView != NULL)
      {
          this->viewerBase->AddActorsPlane(0, this->xView->GetRenderWindow(), this->xView->GetDefaultRenderer());
      }     
  
      if ( this->bView != NULL)
      {
          this->viewerBase->AddActorsBar(this->bView->GetDefaultRenderer());
      }
   
      int zsize = this->viewerBase->GetZSize();
      int ysize = this->viewerBase->GetYSize();
      int xsize = this->viewerBase->GetXSize();
      this->xSlider->bounds(0, xsize);
      this->ySlider->bounds(0, ysize);
      this->zSlider->bounds(0, zsize);
      this->xSlider->value((xsize+1)/2);
      this->ySlider->value((ysize+1)/2);
      this->zSlider->value((zsize+1)/2);
      SetXSlice((xsize+1)/2);
      SetYSlice((ysize+1)/2);
      SetZSlice((zsize+2)/2);
      this->levelSlider->value(0.5);
      this->windowSlider->value(1.0);
      this->Render();
  }
}

void ViewerGUI::Show(int aArgc, char* aArgv[]) {
  if (this->mWindow != (Fl_Window *) 0)
  {
      this->mWindow->show(aArgc, aArgv);
      Show();
  }
}

void ViewerGUI::SetZSlice(unsigned short slice) {
  viewerBase->SetZSlice(slice);
  this->Render();
}

void ViewerGUI::SetYSlice(unsigned short slice) {
  viewerBase->SetYSlice(slice);
  this->Render();
}

void ViewerGUI::SetXSlice(unsigned short slice) {
  viewerBase->SetXSlice(slice);
  this->Render();
}

void ViewerGUI::Render() {
  this->volView->GetRenderWindow()->Render();
  this->xView->GetRenderWindow()->Render();
  this->yView->GetRenderWindow()->Render();
  this->zView->GetRenderWindow()->Render();
  this->bView->GetRenderWindow()->Render();
}

void ViewerGUI::MakeGraph() {
  int zsize = this->viewerBase->GetZSize();
  int ysize = this->viewerBase->GetYSize();
  int xsize = this->viewerBase->GetXSize();
  int zSlice = viewerBase->GetZSlice();
  int ySlice = viewerBase->GetYSlice();
  int xSlice = viewerBase->GetXSlice();
  int sel = intersectChoice->value();
  int max = (sel == 0 ? xsize : (sel == 1 ? ysize : zsize )) + 1;
  xAxis->maximum(max);
  
  double* line = new double[max];
  double* yData = new double[max];
  double* xData = new double[max];
  double maxValue = -1e10;
  double minValue = 1e10;
  viewerBase->GetLine(line, zSlice, ySlice, xSlice, sel);
  for ( int i = 0; i < max; i++ )
  {
      if ( maxValue < line[i] ) 
      {
          maxValue = line[i];
      }
      if ( minValue > line[i] ) 
      {
          minValue = line[i];
      }
      yData[i] = line[i];
      xData[i] = (double)i;
  }
  
  if ( activeGraph && (minValue < maxValue) ) 
  { 
      if ( maxValue > yAxis->maximum() )
      {
          yAxis->maximum(maxValue);
      }
      if ( minValue < yAxis->minimum() )
      {
          yAxis->minimum(minValue);
      }
  }
  else if ( !activeGraph && (minValue < maxValue)) 
  {
      yAxis->maximum(maxValue);
      if ( (minValue < 1E-12) && (scaleChoice->value() == 1) )
      {
          minValue = 1E-12;
      }
      yAxis->minimum(minValue);
  }
  else
  {
      //printf("ignor min/max\n");
  }
  
  Ca_Line* caLine = new Ca_Line(max, xData, yData, 0, 0, colorGraph[selColor]);
  selColor = (selColor + 1 ) % 13;
  activeGraph = true;
}
