/****************************************************************************
 * Copyright (c) 2007 Einir Valdimarsson and Chrysanthe Preza
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 ****************************************************************************/
#ifndef _ESTIMATE_SICG_H
#define _ESTIMATE_SICG_H

#include "estimateIterative.h"
#include <complex>
#include "fftwInterface.h"

namespace cosm {

template<typename T, int N>
class EstimateSICG : public EstimateIterative<T,N> {

  public:

    // class constructor
    EstimateSICG(
	Array<T,N>& psf,
	Array<T,N>& img,
	int iterations,
    T regularization,
    T epsilon = 1E-5
    );

    // class destructor
    virtual ~EstimateSICG() { };

    // Function to specify the raw image
    virtual void setImage( 
	Array<T,N>& img 
    );

  protected:

    // Function for single iteration of the algorithm
    virtual void iterate();

  private:

    // not allowed
    EstimateSICG( EstimateSICG<T,N>& );
    void operator=( EstimateSICG<T,N>& );

    // Function to specify the psf
    virtual void setPSF( 
	Array<T,N>& psf 
    );

  protected:
    
    T epsilon_;
    Array<T, N> s_, dk_, Kss_, rk_, b_;
    Array<T, N> psfResized_;
    T rkNormOld_, nrk_, gamma_, lambda_, beta_, regularization_;
};

}

#include "estimateSICG.c"

#endif  // _ESTIMATE_SICG_H
